---
title: Egress policies · Cloudflare One docs
description: When your users connect to the Internet through Cloudflare Gateway,
  by default their traffic is assigned a source IP address that is shared across
  all Cloudflare WARP users. Enterprise users can purchase dedicated egress IPs
  to ensure that egress traffic from your organization is assigned a unique,
  static IP. These source IPs are dedicated to your account and can be used
  within allowlists on upstream services.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/index.md
---

Note

Only available on Enterprise plans.

When your users connect to the Internet through Cloudflare Gateway, by default their traffic is assigned a source IP address that is shared across all Cloudflare WARP users. Enterprise users can purchase [dedicated egress IPs](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/) to ensure that egress traffic from your organization is assigned a unique, static IP. These source IPs are dedicated to your account and can be used within allowlists on upstream services.

Egress policies allow you to control which dedicated egress IP is used and when, based on attributes such as identity, IP address, and geolocation. Traffic that does not match an egress policy will default to using the most performant dedicated egress IP.

Cloudflare does not publish WARP egress IP ranges. WARP egress IPs are not documented at [Cloudflare's IP Ranges](https://cloudflare.com/ips). To obtain a dedicated WARP egress IP, contact your account team.

Terraform provider v4 precedence limitation

To avoid conflicts, version 4 of the Terraform Cloudflare provider applies a hash calculation to policy precedence. For example, a precedence of `1000` may become `1000901`. This can cause errors when reordering policies. To avoid this issue, manually set the precedence of policies created with Terraform using the [Update a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/update/) endpoint.

To ensure your precedence is set correctly, Cloudflare recommends [upgrading your Terraform provider to version 5](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade).

## Load balancing

When using either the default Cloudflare egress IPs or any dedicated egress IPs, Gateway traffic that does not match an egress policy will egress from the closest Cloudflare data center with a default Gateway egress IP. If there are two data centers of equal distance from the user, Gateway will split the traffic between the two data centers, and the load balancer will retain the same user selection and egress IP regardless of data center.

## Force IP version

To control whether only IPv4 or IPv6 is used to egress, ensure you are [filtering DNS traffic](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/dns/), then create a DNS policy to [block AAAA or A records](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/common-policies/#control-ip-version).

## Example policies

The following egress policy configures all traffic destined for a third-party network to use a static source IP:

| Policy name | Selector | Operator | Value | Egress method |
| - | - | - | - | - |
| Access third-party provider | Destination IP | is | `198.51.100.158` | Dedicated Cloudflare egress IPs |

| Primary IPv4 address | IPv6 address |
| - | - |
| `203.0.113.88` | `2001:db8::/32` |

### Catch-all policy

For the best performance, we recommend creating a catch-all policy to route all other users through the default Zero Trust IP range:

| Policy name | Selector | Operator | Value | Egress method |
| - | - | - | - | - |
| Default egress policy | Protocol | in | `All options (Protocol)` | Cloudflare default egress method |

Since Gateway policies evaluate from [top to bottom](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/#order-of-precedence) in the UI, be sure to place the catch-all policy at the bottom of the list. If you do not include a catch-all policy, all other traffic will attempt to use the closest dedicated egress IP location. To control which egress IP Gateway uses, create an egress policy.

## Egress methods

Choose one of the following options for your egress policy:

* **Use default Cloudflare egress method** uses the default source IP range shared across all Zero Trust accounts. Ensures the most performant Internet experience as user traffic egresses from the nearest Cloudflare data center.

* **Use dedicated egress IPs (Cloudflare or BYOIP)** uses the primary IPv4 address and IPv6 range selected in the dropdown menus. You can optionally specify a secondary IPv4 address in a different data center. If the primary data center goes down, Gateway will egress from the secondary data center to avoid traffic drops during reroutes. There is no need for a secondary IPv6 because IPv6 traffic can egress from any Cloudflare data center. Dedicated egress IPs can be provided by either Cloudflare or [BYOIP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/#bring-your-own-ip-address-byoip). To learn more about IPv4 and IPv6 egress behavior, refer to [Egress locations](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/#egress-location).

## Selectors

Gateway matches egress traffic against the following selectors, or criteria:

### Application Beta

You can apply egress policies to a growing list of popular web applications. Refer to [Application and app types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/) for more information.

| UI name | API example |
| - | - |
| Application | `any(app.ids[*] in {505})` |

This selector is only available for traffic onboarded to Gateway with WARP, PAC files, or Browser Isolation. For more information, refer to [Selector prerequisites](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

### Content Categories Beta

Applications within a specific [security category](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#content-categories) as categorized by [Cloudflare Radar](https://developers.cloudflare.com/radar/glossary/#content-categories).

| UI name | API example |
| - | - |
| Content Categories | `any(net.fqdn.content_category[*] in {1})` |

This selector is only available for traffic onboarded to Gateway with WARP, PAC files, or Browser Isolation. For more information, refer to [Selector prerequisites](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

### Destination Continent

The continent where the request is destined. Geolocation is determined from the target IP address. To specify a continent, enter its two-letter code into the **Value** field:

| Continent | Code |
| - | - |
| Africa | `AF` |
| Antarctica | `AN` |
| Asia | `AS` |
| Europe | `EU` |
| North America | `NA` |
| Oceania | `OC` |
| South America | `SA` |
| Tor network | `T1` |

| UI name | API example |
| - | - |
| Destination Continent IP Geolocation | `net.dst.geo.continent == "EU"` |

### Destination Country

The country that the request is destined for. Geolocation is determined from the target IP address. To specify a country, enter its [ISO 3166-1 Alpha 2 code](https://www.iso.org/obp/ui/#search/code/) in the **Value** field.

| UI name | API example |
| - | - |
| Destination Country IP Geolocation | `net.dst.geo.country == "RU"` |

### Destination IP

The IP address of the request's target.

| UI name | API example |
| - | - |
| Destination IP | `any(net.dst.ip[*] in {10.0.0.0/8})` |

### Destination Port

The port number of the request's target.

| UI name | API example |
| - | - |
| Destination Port | `net.dst.port == 2222` |

### Device Posture

With the Device Posture selector, admins can use signals from end-user devices to secure access to their internal and external resources. For example, a security admin can choose to limit all access to internal applications based on whether specific software is installed on a device and/or if the device or software are configured in a particular way.

For more information on device posture checks, refer to [Device posture](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/).

| UI name | API example |
| - | - |
| Passed Device Posture Checks | `any(device_posture.checks.failed[*] in {"1308749e-fcfb-4ebc-b051-fe022b632644"})`, `any(device_posture.checks.passed[*] in {"1308749e-fcfb-4ebc-b051-fe022b632644"})"` |

### Domain Beta

Use this selector to match against a domain and all subdomains. For example, you can match `example.com` and its subdomains, such as `www.example.com`.

| UI name | API example |
| - | - |
| Domain | `any(net.fqdn.domains[*] == "example.com")` |

Gateway policies do not support domains with non-Latin characters directly. To use a domain with non-Latin characters, add it to a [list](https://developers.cloudflare.com/cloudflare-one/reusable-components/lists/).

This selector is only available for traffic onboarded to Gateway with WARP, PAC files, or Browser Isolation. For more information, refer to [Selector prerequisites](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

### Host Beta

Use this selector to match against only the hostname specified. For example, you can match `test.example.com` but not `example.com` or `www.test.example.com`.

| UI name | API example |
| - | - |
| Host | `net.fqdn.host == "example.com"` |

Gateway policies do not support hostnames with non-Latin characters directly. To use a hostname with non-Latin characters, add it to a [list](https://developers.cloudflare.com/cloudflare-one/reusable-components/lists/).

Note

Some hostnames (`example.com`) will invisibly redirect to the www subdomain (`www.example.com`). To match this type of website, use the [Domain](#domain) selector instead of the Host selector.

This selector is only available for traffic onboarded to Gateway with WARP, PAC files, or Browser Isolation. For more information, refer to [Selector prerequisites](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

### Protocol

The protocol used to send the packet.

| UI name | API example |
| - | - |
| Protocol | `net.protocol == "tcp"` |

### Proxy Endpoint

The [proxy server](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/) where your browser forwards HTTP traffic.

| UI name | API example |
| - | - |
| Proxy Endpoint | `proxy.endpoint == "3ele0ss56t.proxy.cloudflare-gateway.com"` |

### Source Continent

The continent of the user making the request.

Geolocation is determined from the device's public IP address (typically assigned by the user's ISP). To specify a continent, enter its two-letter code into the **Value** field:

| Continent | Code |
| - | - |
| Africa | `AF` |
| Antarctica | `AN` |
| Asia | `AS` |
| Europe | `EU` |
| North America | `NA` |
| Oceania | `OC` |
| South America | `SA` |
| Tor network | `T1` |

| UI name | API example |
| - | - |
| Source Continent IP Geolocation | `net.src.geo.continent == "North America"` |

### Source Country

The country of the user making the request.

Geolocation is determined from the device's public IP address (typically assigned by the user's ISP). To specify a country, enter its [ISO 3166-1 Alpha-2 code](https://www.iso.org/obp/ui/#search/code/) in the **Value** field.

| UI name | API example |
| - | - |
| Source Country IP Geolocation | `net.src.geo.country == "RU"` |

### Source Internal IP

Use this selector to apply egress policies to a private IP address, assigned by a user's local network, that requests arrive to Gateway from. This selector will only apply to users connected through a [Magic GRE or IPSec tunnel](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/).

| UI name | API example |
| - | - |
| Source Internal IP | `net.src.internal_src_ip == "192.168.86.0/27"` |

### Source IP

The originating IP address or addresses of a device proxied by Gateway.

| UI name | API example |
| - | - |
| Source IP | `net.src.ip[*] in {10.0.0.0/8}` |

### Source Port

The originating port of a device proxied by Gateway.

| UI name | API example |
| - | - |
| Source Port | `net.src.port == "2222"` |

### Users

Use these selectors to match against identity attributes.

| UI name | API example |
| - | - |
| User Email | `identity.email == "user@example.com"` |
| User Name | `identity.name == "Test User"` |
| User Group IDs | `any(identity.groups[*].id in {"group_id"})` |
| User Group Names | `any(identity.groups[*].name in {"group_name"})` |
| User Group Emails | `any(identity.groups[*].email in {"group@example.com"})` |
| SAML Attributes | `any(identity.saml_attributes["http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name"] in {"Test User"})` |

### Virtual Network

Use this selector to match all traffic routed through a specific [Tunnel Virtual Network](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/tunnel-virtual-networks/) via the WARP client.

| UI name | API example |
| - | - |
| Virtual Network | `net.vnet_id == "957fc748-591a-e96s-a15d-1j90204a7923"` |

## Comparison operators

Comparison operators are the way Gateway matches traffic to a selector. When you choose a **Selector** in the dashboard policy builder, the **Operator** dropdown menu will display the available options for that selector.

| Operator | Meaning |
| - | - |
| is | equals the defined value |
| is not | does not equal the defined value |
| in | matches at least one of the defined values |
| not in | does not match any of the defined values |
| in list | in a pre-defined [list](https://developers.cloudflare.com/cloudflare-one/reusable-components/lists/) of values |
| not in list | not in a pre-defined [list](https://developers.cloudflare.com/cloudflare-one/reusable-components/lists/) of values |
| matches regex | regex evaluates to true |
| does not match regex | regex evaluates to false |
| greater than | exceeds the defined number |
| greater than or equal to | exceeds or equals the defined number |
| less than | below the defined number |
| less than or equal to | below or equals the defined number |

## Value

You can input a single value or use regular expressions to specify a range of values.

Gateway uses Rust to evaluate regular expressions. The Rust implementation is slightly different than regex libraries used elsewhere. To evaluate if your regex matches, you can use [Rustexp](https://rustexp.lpil.uk/).

## Logical operators

To evaluate multiple conditions in an expression, select the **And** logical operator. These expressions can be compared further with the **Or** logical operator.

| Operator | Meaning |
| - | - |
| And | match all of the conditions in the expression |
| Or | match any of the conditions in the expression |

The **Or** operator will only work with conditions in the same expression group. For example, you cannot compare conditions in **Traffic** with conditions in **Identity** or **Device Posture**.

## Limitations

### Selector prerequisites

The [Application](#application), [Content Categories](#content-categories), [Domain](#domain), and [Host](#host) selectors require configuration changes in order to be operational. Before deploying policies with these selectors, refer to [Host selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/host-selectors).
